-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Servidor: 127.0.0.1:3306
-- Tiempo de generación: 26-01-2026 a las 19:48:42
-- Versión del servidor: 9.1.0
-- Versión de PHP: 8.3.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Base de datos: `citas_medicas`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asistencia_cursos`
--

DROP TABLE IF EXISTS `asistencia_cursos`;
CREATE TABLE IF NOT EXISTS `asistencia_cursos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `documento` varchar(20) NOT NULL COMMENT 'Documento del usuario',
  `nompa` varchar(100) DEFAULT NULL COMMENT 'Nombre del usuario',
  `apepa` varchar(100) DEFAULT NULL COMMENT 'Apellido del usuario',
  `idcurso` int NOT NULL COMMENT 'ID del curso',
  `fecha` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `tipo` enum('ENTRADA','SALIDA') NOT NULL DEFAULT 'ENTRADA',
  `motivo` text,
  PRIMARY KEY (`id`),
  KEY `idx_documento` (`documento`),
  KEY `idx_idcurso` (`idcurso`),
  KEY `idx_fecha` (`fecha`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci COMMENT='Tabla de asistencia exclusiva para cursos';

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `asistencia_qr`
--

DROP TABLE IF EXISTS `asistencia_qr`;
CREATE TABLE IF NOT EXISTS `asistencia_qr` (
  `id` int NOT NULL AUTO_INCREMENT,
  `documento` varchar(20) NOT NULL,
  `nompa` varchar(100) DEFAULT NULL,
  `apepa` varchar(100) DEFAULT NULL,
  `fecha` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `tipo` enum('ENTRADA','SALIDA') NOT NULL DEFAULT 'ENTRADA',
  `motivo` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `asistencia_qr`
--

INSERT INTO `asistencia_qr` (`id`, `documento`, `nompa`, `apepa`, `fecha`, `tipo`, `motivo`) VALUES
(1, '65564', 'JUAN', 'ASDS', '2026-01-23 19:28:41', 'ENTRADA', ''),
(2, '65564', 'JUAN', 'ASDS', '2026-01-23 19:29:15', 'SALIDA', 'Enfermo');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `base`
--

DROP TABLE IF EXISTS `base`;
CREATE TABLE IF NOT EXISTS `base` (
  `idb` int NOT NULL AUTO_INCREMENT,
  `base` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idb`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cart`
--

DROP TABLE IF EXISTS `cart`;
CREATE TABLE IF NOT EXISTS `cart` (
  `idv` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `idprcd` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  PRIMARY KEY (`idv`),
  KEY `user_id` (`user_id`),
  KEY `idprcd` (`idprcd`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `category`
--

DROP TABLE IF EXISTS `category`;
CREATE TABLE IF NOT EXISTS `category` (
  `idcat` int NOT NULL AUTO_INCREMENT,
  `nomcat` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idcat`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `consult`
--

DROP TABLE IF EXISTS `consult`;
CREATE TABLE IF NOT EXISTS `consult` (
  `idconslt` int NOT NULL AUTO_INCREMENT,
  `mtcl` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `signo_vital` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `SV` varchar(22) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FC` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `FR` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TMP` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `T` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `P` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `IMC` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PA` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PC` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `GL` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TV` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TA` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `CB_CL` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `NEU` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `TRX` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `DOR` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ABD` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `PIE` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `GUN` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `EXT` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `LIM` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idconslt`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `consult`
--

INSERT INTO `consult` (`idconslt`, `mtcl`, `idpa`, `nompa`, `state`, `fere`, `signo_vital`, `SV`, `FC`, `FR`, `TMP`, `T`, `P`, `IMC`, `PA`, `PC`, `GL`, `TV`, `TA`, `CB_CL`, `NEU`, `TRX`, `DOR`, `ABD`, `PIE`, `GUN`, `EXT`, `LIM`) VALUES
(1, 'jkh', 748, 'JUAN', '1', '2026-01-26 19:28:31', '', 'khkj', 'hkj', 'hkj', 'hkj', 'hkj', 'hkj', 'hk', 'jhkj', 'hk', 'hj', 'hk', 'jhk', '', 'jhk', 'jh', 'kjh', 'kjh', 'j', 'hk', 'jhk', 'jhk');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cursos`
--

DROP TABLE IF EXISTS `cursos`;
CREATE TABLE IF NOT EXISTS `cursos` (
  `idcurso` int NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `quien_lo_da` varchar(100) NOT NULL,
  `es_titulado` enum('sí','no') NOT NULL,
  `en_que` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`idcurso`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `doctor`
--

DROP TABLE IF EXISTS `doctor`;
CREATE TABLE IF NOT EXISTS `doctor` (
  `idodc` int NOT NULL AUTO_INCREMENT,
  `ceddoc` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nodoc` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `apdoc` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nomesp` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `direcd` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sexd` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `phd` char(13) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nacd` date NOT NULL,
  `corr` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `username` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rol` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idodc`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `doctor`
--

INSERT INTO `doctor` (`idodc`, `ceddoc`, `nodoc`, `apdoc`, `nomesp`, `direcd`, `sexd`, `phd`, `nacd`, `corr`, `username`, `password`, `rol`, `state`, `fere`) VALUES
(44, '7777711', 'jhon', 'rubiano', 'Oftalmología', 'sss', 'Masculino', '32121321', '1994-12-30', 'jhon@gmail.com', 'jhon', 'e807f1fcf82d132f9bb018ca6738a19f', '1', '1', '2026-01-26 19:41:04'),
(45, '77777122', 'camilo', 'flores', 'Geriatría', 'dd', 'Masculino', '6546465', '1988-12-31', 'dd@gmial.com', 'camilo', 'e807f1fcf82d132f9bb018ca6738a19f', '4', '1', '2026-01-26 19:43:17');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `document`
--

DROP TABLE IF EXISTS `document`;
CREATE TABLE IF NOT EXISTS `document` (
  `iddoc` int NOT NULL AUTO_INCREMENT,
  `nomfi` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `foto` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tipo` varchar(20) COLLATE utf8mb3_unicode_ci DEFAULT 'general',
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`iddoc`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `document`
--

INSERT INTO `document` (`iddoc`, `nomfi`, `foto`, `idpa`, `nompa`, `state`, `tipo`, `fere`) VALUES
(6, 'eps', '618916.png', 746, 'JUAN', '1', 'general', '2026-01-23 19:50:38'),
(7, 'SISBEN', '747515.png', 747, 'JHON RUBIANO', '1', 'general', '2026-01-26 12:22:34'),
(8, '', '961381.pdf', 747, 'JHON RUBIANO', '1', 'general', '2026-01-26 12:22:58'),
(11, 'pdf', '608674.pdf', 748, 'JUAN', '1', 'general', '2026-01-26 15:00:08'),
(12, 'cedula', '269148.pdf', 748, 'JUAN', '1', 'general', '2026-01-26 15:00:59'),
(13, 'ASA', '757224.', 748, 'JUAN', '1', 'general', '2026-01-26 15:05:34'),
(14, 'EPS', '992593.pdf', 752, 'K', '1', 'general', '2026-01-26 16:29:34'),
(15, '', '30703.pdf', 752, 'K', '1', 'general', '2026-01-26 16:30:00'),
(17, 'eps', '282207.pdf', 751, 'JHGH', '1', 'general', '2026-01-26 16:43:55'),
(18, 'Cedula\r\n', '593086.jpg', 751, 'JHGH', '1', 'general', '2026-01-26 17:05:16'),
(19, 'firma\r\n', '863895.jpg', 751, 'JHGH', '1', 'firma', '2026-01-26 17:08:13'),
(21, 'Autorización Tratamiento de Datos - AUTORIZADO: SÍ - AUTORIZADO: SÍ', 'check_mark.png', 751, 'JHGH', '1', 'autorizacion', '2026-01-26 18:58:11'),
(22, 'Autorización Tratamiento de Datos - AUTORIZADO: SÍ - AUTORIZADO: SÍ', 'check_mark.png', 751, 'JHGH', '1', 'autorizacion', '2026-01-26 18:58:21'),
(29, 'ss', '369323.png', 748, 'JUAN', '1', 'firma', '2026-01-26 19:17:10'),
(30, 'Autorización Tratamiento de Datos - AUTORIZADO: SÍ - AUTORIZADO: SÍ', 'check_mark.png', 748, 'JUAN', '1', 'autorizacion', '2026-01-26 19:22:38'),
(31, 'sad', '542907.png', 748, 'JUAN', '1', 'general', '2026-01-26 19:24:44');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `events`
--

DROP TABLE IF EXISTS `events`;
CREATE TABLE IF NOT EXISTS `events` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `idodc` int NOT NULL,
  `idlab` int NOT NULL,
  `color` char(14) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `start` datetime NOT NULL,
  `end` datetime DEFAULT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `monto` decimal(10,2) NOT NULL,
  `chec` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idpa` (`idpa`),
  KEY `idodc` (`idodc`),
  KEY `idlab` (`idlab`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `fisioterapia`
--

DROP TABLE IF EXISTS `fisioterapia`;
CREATE TABLE IF NOT EXISTS `fisioterapia` (
  `id` int NOT NULL AUTO_INCREMENT,
  `idpa` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nompa` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fere` datetime NOT NULL,
  `sentarse_levantarse` text COLLATE utf8mb4_unicode_ci,
  `flexiones_brazo` text COLLATE utf8mb4_unicode_ci,
  `flexion_tronco` text COLLATE utf8mb4_unicode_ci,
  `juntar_manos_atras` text COLLATE utf8mb4_unicode_ci,
  `romberg` text COLLATE utf8mb4_unicode_ci,
  `ipaq` text COLLATE utf8mb4_unicode_ci,
  `alcance_funcional` text COLLATE utf8mb4_unicode_ci,
  `barthel` text COLLATE utf8mb4_unicode_ci,
  `funcionalidad` text COLLATE utf8mb4_unicode_ci,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idpa` (`idpa`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Volcado de datos para la tabla `fisioterapia`
--

INSERT INTO `fisioterapia` (`id`, `idpa`, `nompa`, `fere`, `sentarse_levantarse`, `flexiones_brazo`, `flexion_tronco`, `juntar_manos_atras`, `romberg`, `ipaq`, `alcance_funcional`, `barthel`, `funcionalidad`, `state`) VALUES
(2, '748', 'JUAN', '2026-01-26 14:29:12', 'kjn', 'kj', 'kj', 'hkj', 'hkj', 'hkj', 'hkj', 'hkj', 'hkj', 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `genogram`
--

DROP TABLE IF EXISTS `genogram`;
CREATE TABLE IF NOT EXISTS `genogram` (
  `idge` int NOT NULL AUTO_INCREMENT,
  `detage` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idge`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `genogram`
--

INSERT INTO `genogram` (`idge`, `detage`, `idpa`, `nompa`, `state`, `fere`) VALUES
(18, 'aaa', 748, 'JUAN', '1', '2026-01-26 19:28:43');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `idiom`
--

DROP TABLE IF EXISTS `idiom`;
CREATE TABLE IF NOT EXISTS `idiom` (
  `idoma` int NOT NULL AUTO_INCREMENT,
  `nomidi` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idoma`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `inscripciones`
--

DROP TABLE IF EXISTS `inscripciones`;
CREATE TABLE IF NOT EXISTS `inscripciones` (
  `idins` int NOT NULL AUTO_INCREMENT,
  `documento` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL COMMENT 'Relacionado con patients.numhs',
  `idcurso` int NOT NULL COMMENT 'Relacionado con cursos.idcurso',
  `fecha_inscripcion` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL DEFAULT '1' COMMENT '1=Activo, 0=Inactivo',
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idins`),
  KEY `idx_documento` (`documento`),
  KEY `idx_idcurso` (`idcurso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `laboratory`
--

DROP TABLE IF EXISTS `laboratory`;
CREATE TABLE IF NOT EXISTS `laboratory` (
  `idlab` int NOT NULL AUTO_INCREMENT,
  `nomlab` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idlab`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `medicamentos`
--

DROP TABLE IF EXISTS `medicamentos`;
CREATE TABLE IF NOT EXISTS `medicamentos` (
  `id_medicamentos` int NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(30) NOT NULL,
  `fere` timestamp NOT NULL,
  `state` varchar(30) NOT NULL,
  `tomam` varchar(30) NOT NULL,
  `cualm` varchar(30) NOT NULL,
  `prescripcion` varchar(30) NOT NULL,
  `automedicacion` varchar(30) NOT NULL,
  `quirurgicos` varchar(30) NOT NULL,
  `hospitalizacion` varchar(30) NOT NULL,
  `traumaticos` varchar(30) NOT NULL,
  `hipertencion` varchar(30) NOT NULL,
  `toxico` varchar(30) NOT NULL,
  `alergico` varchar(30) NOT NULL,
  `infeccioso` varchar(30) NOT NULL,
  `enfermedadr` varchar(30) NOT NULL,
  `ulcera` varchar(30) NOT NULL,
  `lepra` varchar(30) NOT NULL,
  `diabetes` varchar(30) NOT NULL,
  `asma` varchar(30) NOT NULL,
  `cancer` varchar(30) NOT NULL,
  `epoc` varchar(30) NOT NULL,
  `epilepsia` varchar(30) NOT NULL,
  `autoinmunes` varchar(30) NOT NULL,
  `ingresourgencias` varchar(30) NOT NULL,
  `otrom` varchar(30) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `medicamentos`
--

INSERT INTO `medicamentos` (`id_medicamentos`, `idpa`, `nompa`, `fere`, `state`, `tomam`, `cualm`, `prescripcion`, `automedicacion`, `quirurgicos`, `hospitalizacion`, `traumaticos`, `hipertencion`, `toxico`, `alergico`, `infeccioso`, `enfermedadr`, `ulcera`, `lepra`, `diabetes`, `asma`, `cancer`, `epoc`, `epilepsia`, `autoinmunes`, `ingresourgencias`, `otrom`) VALUES
(0, 748, 'JUAN', '2026-01-26 19:28:10', '1', '', '', '', '', '', '', 'kjnj', 'nkjn', 'jkn', 'kjn', 'jkn', 'jk', 'njk', 'nkj', 'njk', 'nkj', 'nkj', 'nkj', 'nkj', 'nkj', 'nk', 'jnkj'),
(0, 748, 'JUAN', '2026-01-26 19:35:23', '1', 'hgh', 'gg', 'jhg', 'jhg', 'jhgj', 'g', 'jh', 'gjh', 'gjh', 'gj', 'hgj', 'hgj', 'hg', 'jhg', 'jhg', 'jhg', 'jh', 'gjh', 'gj', 'hg', 'jhg', 'jg');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `menu_permissions`
--

DROP TABLE IF EXISTS `menu_permissions`;
CREATE TABLE IF NOT EXISTS `menu_permissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `dashboard` tinyint(1) DEFAULT '1',
  `remisiones` tinyint(1) DEFAULT '0',
  `usuarios` tinyint(1) DEFAULT '0',
  `cursos` tinyint(1) DEFAULT '0',
  `asistencia` tinyint(1) DEFAULT '0',
  `profesionales` tinyint(1) DEFAULT '0',
  `recursos` tinyint(1) DEFAULT '0',
  `ajustes` tinyint(1) DEFAULT '0',
  `acerca` tinyint(1) DEFAULT '1',
  `reportes` tinyint(1) DEFAULT '0',
  `remisiones_todas` tinyint(1) DEFAULT '0',
  `remisiones_nueva` tinyint(1) DEFAULT '0',
  `remisiones_calendario` tinyint(1) DEFAULT '0',
  `usuarios_lista` tinyint(1) DEFAULT '0',
  `usuarios_historial` tinyint(1) DEFAULT '0',
  `usuarios_documentos` tinyint(1) DEFAULT '0',
  `cursos_registro` tinyint(1) DEFAULT '0',
  `cursos_inscripcion` tinyint(1) DEFAULT '0',
  `cursos_asistencia` tinyint(1) DEFAULT '0',
  `profesionales_lista` tinyint(1) DEFAULT '0',
  `profesionales_historial` tinyint(1) DEFAULT '0',
  `recursos_enfermera` tinyint(1) DEFAULT '0',
  `recursos_laboratorios` tinyint(1) DEFAULT '0',
  `ajustes_config` tinyint(1) DEFAULT '0',
  `ajustes_idioma` tinyint(1) DEFAULT '0',
  `ajustes_base_datos` tinyint(1) DEFAULT '0',
  `historia_riesgo_social_ver` tinyint(1) DEFAULT '0',
  `historia_riesgo_social_modificar` tinyint(1) DEFAULT '0',
  `historia_salud_oral_ver` tinyint(1) DEFAULT '0',
  `historia_salud_oral_modificar` tinyint(1) DEFAULT '0',
  `historia_salud_mental_ver` tinyint(1) DEFAULT '0',
  `historia_salud_mental_modificar` tinyint(1) DEFAULT '0',
  `historia_medicamentos_ver` tinyint(1) DEFAULT '0',
  `historia_medicamentos_modificar` tinyint(1) DEFAULT '0',
  `historia_signos_vitales_ver` tinyint(1) DEFAULT '0',
  `historia_signos_vitales_modificar` tinyint(1) DEFAULT '0',
  `historia_diagnostico_ver` tinyint(1) DEFAULT '0',
  `historia_diagnostico_modificar` tinyint(1) DEFAULT '0',
  `historia_antecedentes_ver` tinyint(1) DEFAULT '0',
  `historia_antecedentes_modificar` tinyint(1) DEFAULT '0',
  `historia_examenes_ver` tinyint(1) DEFAULT '0',
  `historia_examenes_modificar` tinyint(1) DEFAULT '0',
  `historia_fisioterapia_ver` tinyint(1) DEFAULT '0',
  `historia_fisioterapia_modificar` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `menu_permissions`
--

INSERT INTO `menu_permissions` (`id`, `user_id`, `dashboard`, `remisiones`, `usuarios`, `cursos`, `asistencia`, `profesionales`, `recursos`, `ajustes`, `acerca`, `reportes`, `remisiones_todas`, `remisiones_nueva`, `remisiones_calendario`, `usuarios_lista`, `usuarios_historial`, `usuarios_documentos`, `cursos_registro`, `cursos_inscripcion`, `cursos_asistencia`, `profesionales_lista`, `profesionales_historial`, `recursos_enfermera`, `recursos_laboratorios`, `ajustes_config`, `ajustes_idioma`, `ajustes_base_datos`, `historia_riesgo_social_ver`, `historia_riesgo_social_modificar`, `historia_salud_oral_ver`, `historia_salud_oral_modificar`, `historia_salud_mental_ver`, `historia_salud_mental_modificar`, `historia_medicamentos_ver`, `historia_medicamentos_modificar`, `historia_signos_vitales_ver`, `historia_signos_vitales_modificar`, `historia_diagnostico_ver`, `historia_diagnostico_modificar`, `historia_antecedentes_ver`, `historia_antecedentes_modificar`, `historia_examenes_ver`, `historia_examenes_modificar`, `historia_fisioterapia_ver`, `historia_fisioterapia_modificar`) VALUES
(16, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(19, 48, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0),
(20, 49, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `nurse`
--

DROP TABLE IF EXISTS `nurse`;
CREATE TABLE IF NOT EXISTS `nurse` (
  `idnur` int NOT NULL AUTO_INCREMENT,
  `numide` char(14) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nomnur` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `apenur` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nacinur` date NOT NULL,
  `sexnur` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idnur`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `orders`
--

DROP TABLE IF EXISTS `orders`;
CREATE TABLE IF NOT EXISTS `orders` (
  `idord` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `nomcl` varchar(70) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `method` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `total_products` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `total_price` decimal(10,2) NOT NULL,
  `placed_on` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `payment_status` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tipc` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idord`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `patients`
--

DROP TABLE IF EXISTS `patients`;
CREATE TABLE IF NOT EXISTS `patients` (
  `idpa` int NOT NULL AUTO_INCREMENT,
  `numhs` varchar(10) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `nompa` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `apepa` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `direc` varchar(150) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sex` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `grup` varchar(15) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `phon` char(13) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tiene_whatsapp` varchar(2) COLLATE utf8mb3_unicode_ci DEFAULT 'NO',
  `cump` date NOT NULL,
  `corr` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `username` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rol` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modalidad` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tusuario` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tdocumento` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fexpedicion` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `lexpedicion` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ecivil` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `zona` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `barrio` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `correo` varchar(70) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rbono` varchar(39) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sisben` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `pensionado` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tsudadera` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tchaqueta` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tzapatos` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `talentof` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `observacionsalida` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `vivecomp` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `redapoyo` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `cuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `pcuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `zcuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `bvccuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `dcuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `tcuidador` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `sgsss` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `eps` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `etnia` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `educacion` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `leer` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `utecnologia` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `poblaciond` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `poblacionoficio` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `qrInput` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci,
  `fotoperfil` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idpa`)
) ENGINE=InnoDB AUTO_INCREMENT=754 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `patients`
--

INSERT INTO `patients` (`idpa`, `numhs`, `nompa`, `apepa`, `direc`, `sex`, `grup`, `phon`, `tiene_whatsapp`, `cump`, `corr`, `username`, `password`, `rol`, `state`, `fere`, `modalidad`, `tusuario`, `tdocumento`, `fexpedicion`, `lexpedicion`, `ecivil`, `zona`, `barrio`, `correo`, `rbono`, `sisben`, `pensionado`, `tsudadera`, `tchaqueta`, `tzapatos`, `talentof`, `observacionsalida`, `vivecomp`, `redapoyo`, `cuidador`, `pcuidador`, `zcuidador`, `bvccuidador`, `dcuidador`, `tcuidador`, `sgsss`, `eps`, `etnia`, `educacion`, `leer`, `utecnologia`, `poblaciond`, `poblacionoficio`, `qrInput`, `fotoperfil`) VALUES
(748, '1007863612', 'JUAN', 'ROJAS', 'DDSAD', 'MASCULINO', 'A-', '5456456412', 'NO', '2000-12-31', '', '', '', '', '1', '2026-01-26 19:25:47', 'CENTRO DíA LA PAZ', 'ANTIGUO', 'C.C', '31/12/2022', 'SBATE', 'CASADO', 'CENTRO POBLADO', 'LA RESERVA', 'ASDAS', 'NO', 'C1', 'SI', 'M', 'M', 'SADASD', 'SADASD', 'a', 'SAD', 'SI', 'lkjlj', 'CÓNYUGE y/o COMPAÑERO', 'Urbano', 'la paz', 'jhjg', 'kj54456', 'Contributivo', 'SANITAS', 'INDIGENA', 'PRIMARIA', 'SI', 'SI', 'discapacidad', 'Reciclador', '1007863612', '1007863612_1769434471.jpg'),
(749, '21321321', 'ASDSAADS', 'ASD', 'ASDDSAD', 'MASCULINO', 'A-', '221213', 'SI', '2026-01-26', '', '', '', '', '1', '2026-01-26 15:57:34', 'SELECCIONE', 'NUEVO', 'C.E', '26/01/2026', 'ADSDSA', 'SOLTERO', 'RURAL', 'PARQUES DEL MUñA', 'asdas@gmail.com', 'SI', 'B7', 'SI', 'M', 'M', '321', 'dsf', '', '231', 'NO', 'dsa', 'Hijo', 'Urbano', 'la reserva', 'CR 79C 73D -70 SUR', '77', 'Contributivo', 'Capital Salud EPS-S', 'AFROCOLOMBIANO', 'SECUNDARIA', 'SI', 'NO', 'desplazada', 'Bodegueros', '21321321', '21321321_1769443054.jpg'),
(750, '23424324', 'ASDSAD', 'SADSAD', 'SADSAD', 'FEMENINO', 'A+', '321123e3', 'SI', '2026-01-26', '', '', '', '', '1', '2026-01-26 16:04:19', 'CENTRO DíA NERUDA G1', 'ANTIGUO', 'C.C', '26/01/2026', 'CSAD', 'CASADO', 'URBANA', 'PARQUES DEL MUñA', 'asdsadsa@gmail.com', 'SI', 'B4', 'SI', 'S', 'L', 'asdsad', '213', '', 'adsasd', 'SI', 'asd', 'Hijo', 'Rural', 'la reserva', 'aasddas', 'asdads', 'Subsidiado', 'Famisanar EPS', 'INDIGENA', 'TECNICA', 'SI', 'SI', 'habitante calle', 'Bodegueros', '23424324', '23424324_1769443459.png'),
(751, '654564', 'JHGH', 'HGHJ', 'JHGHJ', 'MASCULINO', 'A+', '654564', 'SI', '2026-01-08', '', '', '', '', '1', '2026-01-26 16:17:02', 'CENTRO DíA BRADAMONTE', 'ANTIGUO', 'C.C', '31/12/2026', 'AAA', 'CASADO', 'URBANA', 'LA PAZ', 'KJGHJ', 'SI', 'A1', 'SI', 'S', 'S', 'JHGHJ', 'SZS', '', 'JHJ', 'SI', 'JHJH', 'CÓNYUGE y/o COMPAÑERO', 'Urbano', 'la paz', 'JHJH', 'KJLHJK', 'Subsidiado', 'SANITAS', 'AFROCOLOMBIANO', 'PRIMARIA', 'SI', 'SI', 'discapacidad', 'Reciclador', '654564', '654564_1769444222.png'),
(752, 'k', 'K', 'JHHJK', 'SADASDSD', 'MASCULINO', 'A-', '213321312', 'NO', '1111-05-20', '', '', '', '', '1', '2026-01-26 16:29:16', 'CENTRO DíA NERUDA G1', 'ANTIGUO', 'SELECCIONE', '05/02/1994', 'ASDAS', 'SOLTERO', 'URBANA', 'GARCíA', 'asdads@gmasil.com', 'SI', 'C3', 'SI', 'S', 'xS', '22', '22', '', '22', 'SI', '22', 'Familia', 'Rural', 'parques del muña', '22', '22', 'Subsidiado', 'Comfenalco Valle', 'PALENQUERO', 'SECUNDARIA', 'SI', 'SI', 'habitante calle', 'Reciclador', 'k', 'k_1769444956.png'),
(753, '9844464564', 'PEPE', 'HJJH', 'NHJKH', 'MASCULINO', 'A+', 'kjh', 'SI', '2026-01-07', '', '', '', '', '1', '2026-01-26 19:37:57', 'SATéLITE SAN MIGUEL', 'ANTIGUO', 'C.C', '31/12/2021', 'ñLKJKL', 'CASADO', 'URBANA', 'LA PAZ', 'kjh', 'SI', 'A1', 'SI', 'S', 'S', 'jh', 'kjhjkh', '', 'jbhvb', 'SI', 'kjhkjh', 'CÓNYUGE y/o COMPAÑERO', 'Urbano', 'la paz', 'jnhjkh', 'kjhjk', 'Contributivo', 'SANITAS', 'INDIGENA', 'PRIMARIA', 'SI', 'SI', 'discapacidad', 'Reciclador', '9844464564', '9844464564_1769456277.png');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `product`
--

DROP TABLE IF EXISTS `product`;
CREATE TABLE IF NOT EXISTS `product` (
  `idprcd` int NOT NULL AUTO_INCREMENT,
  `codpro` char(14) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `nompro` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idcat` int NOT NULL,
  `preprd` decimal(10,2) NOT NULL,
  `stock` char(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idprcd`),
  KEY `idcat` (`idcat`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `saludmental`
--

DROP TABLE IF EXISTS `saludmental`;
CREATE TABLE IF NOT EXISTS `saludmental` (
  `id_saludmental` int NOT NULL,
  `idpa` varchar(30) NOT NULL,
  `nompa` varchar(30) NOT NULL,
  `fere` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `maltrato` varchar(30) NOT NULL,
  `problemas` varchar(30) NOT NULL,
  `sentidomal` varchar(30) NOT NULL,
  `arrepentido` varchar(30) NOT NULL,
  `abandono` varchar(30) NOT NULL,
  `obligado` varchar(30) NOT NULL,
  `cuerpo` varchar(30) NOT NULL,
  `subido` varchar(30) NOT NULL,
  `vomito` varchar(30) NOT NULL,
  `apetito` varchar(30) NOT NULL,
  `reconocimiento` varchar(30) NOT NULL,
  `emborracho` varchar(30) NOT NULL,
  `sustancia` varchar(30) NOT NULL,
  `bebida` varchar(30) NOT NULL,
  `cigarrillo` varchar(30) NOT NULL,
  `aconsejado` varchar(30) NOT NULL,
  `bebidaalta` varchar(30) NOT NULL,
  `beberpodido` varchar(30) NOT NULL,
  `aburrido` varchar(30) NOT NULL,
  `frecuencia` varchar(30) NOT NULL,
  `actividadesf` varchar(30) NOT NULL,
  `tomardecisiones` varchar(30) NOT NULL,
  `agresividad` varchar(30) NOT NULL,
  `ptriste` varchar(30) NOT NULL,
  `ptemeroso` varchar(30) NOT NULL,
  `muerte` varchar(30) NOT NULL,
  `dano` varchar(30) NOT NULL,
  `aislado` varchar(30) NOT NULL,
  `motiva1` varchar(30) NOT NULL,
  `sentimiento` varchar(30) NOT NULL,
  `dificil` varchar(30) NOT NULL,
  `habilidad` varchar(30) NOT NULL,
  `alegreyanimo` varchar(30) NOT NULL,
  `relajadotranquilidad` varchar(30) NOT NULL,
  `activoenergia` varchar(30) NOT NULL,
  `biendescanso` varchar(30) NOT NULL,
  `momentointeresante` varchar(30) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `saludmental`
--

INSERT INTO `saludmental` (`id_saludmental`, `idpa`, `nompa`, `fere`, `state`, `maltrato`, `problemas`, `sentidomal`, `arrepentido`, `abandono`, `obligado`, `cuerpo`, `subido`, `vomito`, `apetito`, `reconocimiento`, `emborracho`, `sustancia`, `bebida`, `cigarrillo`, `aconsejado`, `bebidaalta`, `beberpodido`, `aburrido`, `frecuencia`, `actividadesf`, `tomardecisiones`, `agresividad`, `ptriste`, `ptemeroso`, `muerte`, `dano`, `aislado`, `motiva1`, `sentimiento`, `dificil`, `habilidad`, `alegreyanimo`, `relajadotranquilidad`, `activoenergia`, `biendescanso`, `momentointeresante`) VALUES
(0, '748', 'JUAN', '2026-01-26 14:27:08', '1', 'amammaa', 'ak', 'makmk', 'mkm', 'km', 'km', 'km', 'k', 'mk', 'mk', 'mk', 'mk', 'm', 'kmk', 'mk', 'mk', 'm', 'kmk', 'm', 'km', 'km', 'km', 'km', 'km', 'km', 'km', 'k', 'mkm', 'km', 'km', 'km', 'km', 'k', 'mk', 'mk', 'mk', 'm');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `settings`
--

DROP TABLE IF EXISTS `settings`;
CREATE TABLE IF NOT EXISTS `settings` (
  `idse` int NOT NULL AUTO_INCREMENT,
  `nomem` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `foto` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`idse`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `toral`
--

DROP TABLE IF EXISTS `toral`;
CREATE TABLE IF NOT EXISTS `toral` (
  `id_oral` int NOT NULL,
  `idpa` varchar(30) NOT NULL,
  `nompa` varchar(30) NOT NULL,
  `fere` timestamp NOT NULL,
  `state` varchar(300) NOT NULL,
  `lavadientes` varchar(300) NOT NULL,
  `golpeb` varchar(300) NOT NULL,
  `sangred` varchar(300) NOT NULL,
  `protesisd` varchar(300) NOT NULL,
  `comesonrie` varchar(300) NOT NULL,
  `limpiab` varchar(300) NOT NULL,
  `dolorc` varchar(300) NOT NULL,
  `malolor` varchar(300) NOT NULL,
  `perdidadientes` varchar(300) NOT NULL,
  `maltratoprotesis` varchar(300) NOT NULL,
  `cicatriz` varchar(300) NOT NULL,
  `bocabano` varchar(300) NOT NULL,
  `consultaodont` varchar(300) NOT NULL,
  `observaciones` varchar(300) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `toral`
--

INSERT INTO `toral` (`id_oral`, `idpa`, `nompa`, `fere`, `state`, `lavadientes`, `golpeb`, `sangred`, `protesisd`, `comesonrie`, `limpiab`, `dolorc`, `malolor`, `perdidadientes`, `maltratoprotesis`, `cicatriz`, `bocabano`, `consultaodont`, `observaciones`) VALUES
(0, '748', 'JUAN', '2026-01-26 19:26:43', '1', 'aa', 'a', 'a', 'aa', 'a', 'a', 'a', 'a', 'a', 'a', 'a', 'a', 'a', 'a'),
(0, '748', 'JUAN', '2026-01-26 19:46:28', '1', 'b', 'b', 'b', 'b', 'bbb', 'b', 'b', 'bb', 'b', 'b', 'b', 'b', 'bb', 'b');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `treatment`
--

DROP TABLE IF EXISTS `treatment`;
CREATE TABLE IF NOT EXISTS `treatment` (
  `idtra` int NOT NULL AUTO_INCREMENT,
  `nomtra` text CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `idpa` int NOT NULL,
  `nompa` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `state` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`idtra`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `treatment`
--

INSERT INTO `treatment` (`idtra`, `nomtra`, `idpa`, `nompa`, `state`, `fere`) VALUES
(1, 'aa', 748, 'JUAN', '1', '2026-01-26 19:28:58');

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `ubicaciones_completas`
--

DROP TABLE IF EXISTS `ubicaciones_completas`;
CREATE TABLE IF NOT EXISTS `ubicaciones_completas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nompa` varchar(100) DEFAULT NULL,
  `documento` varchar(20) DEFAULT NULL,
  `correo` varchar(100) DEFAULT NULL,
  `latitud` decimal(9,6) DEFAULT NULL,
  `longitud` decimal(9,6) DEFAULT NULL,
  `fecha_registro` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(25) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `name` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `email` varchar(35) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rol` char(1) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `aprobado` enum('pendiente','aprobado','rechazado') COLLATE utf8mb3_unicode_ci DEFAULT 'pendiente',
  `fecha_aprobacion` datetime DEFAULT NULL,
  `aprobado_por` int DEFAULT NULL,
  `motivo_rechazo` text COLLATE utf8mb3_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Volcado de datos para la tabla `users`
--

INSERT INTO `users` (`id`, `username`, `name`, `email`, `password`, `rol`, `created_at`, `aprobado`, `fecha_aprobacion`, `aprobado_por`, `motivo_rechazo`) VALUES
(1, 'admin', 'Administrador', 'adrianlujam91@gmail.com', 'e807f1fcf82d132f9bb018ca6738a19f', '1', '2025-10-20 21:50:22', 'aprobado', NULL, NULL, NULL),
(27, 'lizsuarez1', 'lizeth suarez', 'lizethsuarez12@gmail.com', '8c2d9f1f37632201ac8a927f00a6283e', '4', '2025-10-20 21:50:22', 'aprobado', NULL, NULL, NULL),
(48, 'jhon', 'jhon rubiano', 'jhon@gmail.com', 'e807f1fcf82d132f9bb018ca6738a19f', '1', '2026-01-26 19:41:04', 'pendiente', NULL, NULL, NULL),
(49, 'camilo', 'camilo flores', 'dd@gmial.com', 'e807f1fcf82d132f9bb018ca6738a19f', '4', '2026-01-26 19:43:17', 'pendiente', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `user_permissions`
--

DROP TABLE IF EXISTS `user_permissions`;
CREATE TABLE IF NOT EXISTS `user_permissions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `view_valoracion_riesgo` tinyint(1) DEFAULT '0',
  `edit_valoracion_riesgo` tinyint(1) DEFAULT '0',
  `view_signos_vitales` tinyint(1) DEFAULT '0',
  `edit_signos_vitales` tinyint(1) DEFAULT '0',
  `view_medicamentos` tinyint(1) DEFAULT '0',
  `edit_medicamentos` tinyint(1) DEFAULT '0',
  `view_diagnostico` tinyint(1) DEFAULT '0',
  `edit_diagnostico` tinyint(1) DEFAULT '0',
  `view_antecedentes` tinyint(1) DEFAULT '0',
  `edit_antecedentes` tinyint(1) DEFAULT '0',
  `view_examenes` tinyint(1) DEFAULT '0',
  `edit_examenes` tinyint(1) DEFAULT '0',
  `view_salud_oral` tinyint(1) DEFAULT '0',
  `edit_salud_oral` tinyint(1) DEFAULT '0',
  `view_salud_mental` tinyint(1) DEFAULT '0',
  `edit_salud_mental` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `user_permissions`
--

INSERT INTO `user_permissions` (`id`, `user_id`, `view_valoracion_riesgo`, `edit_valoracion_riesgo`, `view_signos_vitales`, `edit_signos_vitales`, `view_medicamentos`, `edit_medicamentos`, `view_diagnostico`, `edit_diagnostico`, `view_antecedentes`, `edit_antecedentes`, `view_examenes`, `edit_examenes`, `view_salud_oral`, `edit_salud_oral`, `view_salud_mental`, `edit_salud_mental`) VALUES
(1, 49, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1);

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `valoracionriesgo`
--

DROP TABLE IF EXISTS `valoracionriesgo`;
CREATE TABLE IF NOT EXISTS `valoracionriesgo` (
  `id_valoracion` int NOT NULL,
  `idpa` int NOT NULL,
  `enfermedadd` varchar(30) NOT NULL,
  `fuma` varchar(30) NOT NULL,
  `humo` varchar(30) NOT NULL,
  `consumo` varchar(30) NOT NULL,
  `sal` varchar(30) NOT NULL,
  `cocina` varchar(30) NOT NULL,
  `vestir` varchar(30) NOT NULL,
  `diahoy` varchar(30) NOT NULL,
  `meshoy` varchar(30) NOT NULL,
  `anohoy` varchar(30) NOT NULL,
  `municipio` varchar(30) NOT NULL,
  `nompa` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `fere` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  KEY `fk_valoracionriesgo_patients` (`idpa`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Volcado de datos para la tabla `valoracionriesgo`
--

INSERT INTO `valoracionriesgo` (`id_valoracion`, `idpa`, `enfermedadd`, `fuma`, `humo`, `consumo`, `sal`, `cocina`, `vestir`, `diahoy`, `meshoy`, `anohoy`, `municipio`, `nompa`, `state`, `fere`) VALUES
(0, 748, 'No', 'No', 'No', 'Ni', 'No', 'No', 'No', 'No', 'No', 'No', 'No', 'JUAN', '1', '2026-01-26 13:49:33'),
(0, 748, 'No', 'No', 'No', 'Ni', 'No', 'No', 'No', 'No', 'No', 'No', 'No', 'JUAN', '1', '2026-01-26 13:49:36'),
(0, 748, 'm', 'm', 'm', 'm', 'm', 'm', 'm', 'm', 'm', 'm', 'm', 'JUAN', '1', '2026-01-26 19:26:07');

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `cart`
--
ALTER TABLE `cart`
  ADD CONSTRAINT `cart_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  ADD CONSTRAINT `cart_ibfk_2` FOREIGN KEY (`idprcd`) REFERENCES `product` (`idprcd`);

--
-- Filtros para la tabla `events`
--
ALTER TABLE `events`
  ADD CONSTRAINT `events_ibfk_1` FOREIGN KEY (`idpa`) REFERENCES `patients` (`idpa`),
  ADD CONSTRAINT `events_ibfk_2` FOREIGN KEY (`idodc`) REFERENCES `doctor` (`idodc`),
  ADD CONSTRAINT `events_ibfk_3` FOREIGN KEY (`idlab`) REFERENCES `laboratory` (`idlab`);

--
-- Filtros para la tabla `menu_permissions`
--
ALTER TABLE `menu_permissions`
  ADD CONSTRAINT `menu_permissions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Filtros para la tabla `product`
--
ALTER TABLE `product`
  ADD CONSTRAINT `product_ibfk_1` FOREIGN KEY (`idcat`) REFERENCES `category` (`idcat`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
